
use "./input/country-codes.dta", clear
rename official_name_en country1 
rename ISO4217 base
drop ISO3166
save "./tmp/country_codes_temp_base.dta", replace

use "./input/country-codes.dta", clear
rename official_name_en country2 
rename ISO4217 foreign
drop ISO3166
save "./tmp/country_codes_temp_foreign.dta", replace



use "./input/Bilateral_DeFacto_Regimes.dta", clear

merge m:m country1 using "./tmp/country_codes_temp_base.dta"
drop _merge

merge m:m country2 using "./tmp/country_codes_temp_foreign.dta"
drop _merge

erase "./tmp/country_codes_temp_base.dta"
erase "./tmp/country_codes_temp_foreign.dta"

gen peg = 0
replace peg = 1 if bilateral_defacto_regime == 4
gen peg2 = 0
replace peg2 = 1 if bilateral_defacto_regime <= 4 								

keep year base foreign peg peg2
drop if year == .
drop if base == ""
drop if foreign == ""

sort base foreign year

sa "./output/pegs.dta", replace
